/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.minion;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.MinionEntity;
import entities.missiles.MissileEntity;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public final class MinionShotEntity
extends MissileEntity {
    private long lastFrameChange;
    private Random random = new Random();
    private boolean used = false;

    public MinionShotEntity(MinionEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/minion/" + (parent.isSuperminion() ? "supershot" : "shot"), x, y);
        this.moveSpeed = parent.isSuperminion() ? (double)Math.min(Config.get(Config.superminionShotProjectileSpeed) + Config.get(Config.superminionShotProjectileSpeedPerLevel) * game.getLevel(), Config.get(Config.superminionShotProjectileSpeedCap)) : (double)Math.min(Config.get(Config.minionShotProjectileSpeed) + Config.get(Config.minionShotProjectileSpeedPerLevel) * game.getLevel(), Config.get(Config.minionShotProjectileSpeedCap));
        this.dy = this.moveSpeed;
        this.dx = this.random.nextDouble() * (this.dy / (double)(parent.isSuperminion() ? Config.get(Config.superminionShotAngleDivisor) : Config.get(Config.minionShotAngleDivisor)));
        if (this.random.nextBoolean()) {
            this.dx = -this.dx;
        }
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > 10L) {
            this.lastFrameChange = 0L;
            this.sprite.rotate(45.0f);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.used) {
            return;
        }
        if (other instanceof PlayerCreatureEntity) {
            this.game.removeEntity(this);
            ResourceManager.get().playSound("minion_shot_hit");
            int damage = Config.get(Config.minionShotDamage) + Config.get(Config.minionShotDamagePerLevel) * this.game.getLevel();
            if (((MinionEntity)this.parent).isSuperminion()) {
                damage = (int)((double)damage * Config.get(Config.superminionDamageMultiplier));
            }
            ((CreatureEntity)other).damage(this, damage);
            this.used = true;
        }
    }
}

